#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:2
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=16
#SBATCH --job-name=LP-swav_
#SBATCH --time=60:00:00
#SBATCH --mem=120G
#SBATCH --constraint=v100|rtx6k|rtx8k|p40
#SBATCH --exclude=gnodee8,gnodec1


#tar xf /scratch/shared/beegfs/yuki/data/ILSVRC12.tar -C ${TMPDIR}
#DATASET_PATH=${TMPDIR}/ILSVRC12
DATASET_PATH=/scratch/local/ssd/datasets/Places

EXP_STR="swav/balanced_user-BS256-default"

PYTHON='/scratch/shared/beegfs/yuki/envs/py37/bin/python3'

EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}"
MODEL_STR=${EXPERIMENT_PATH}/checkpoint.pth.tar
EXPERIMENT_PATH+='/LP_swav_places'
mkdir -p $EXPERIMENT_PATH
echo "will use" ${MODEL_STR}

CUDA_VISIBLE_DEVICES=3 ${PYTHON} -m torch.distributed.launch --master_port 10229 --nproc_per_node=1 eval_linear.py \
  --data_path $DATASET_PATH \
  --pretrained $MODEL_STR \
  --dump_path $EXPERIMENT_PATH \
  --batch_size 256 \
  --num_classes 205

